%------------------------------------------------------------------------------
% File     : SEV256^5 : TPTP v7.4.0. Released v4.0.0.
% Domain   : Set Theory (Sets of sets)
% Problem  : TPS problem THM625A
% Version  : Especial.
% English  : THM625 without assuming full topology axioms.

% Refs     : [Bro09] Brown (2009), Email to Geoff Sutcliffe
% Source   : [Bro09]
% Names    : tps_0124 [Bro09]
%          : THM625A [TPS]

% Status   : Theorem
% Rating   : 0.17 v7.4.0, 0.11 v7.3.0, 0.20 v7.2.0, 0.12 v7.1.0, 0.14 v7.0.0, 0.12 v6.4.0, 0.14 v6.3.0, 0.17 v6.2.0, 0.33 v6.1.0, 0.17 v6.0.0, 0.00 v5.5.0, 0.20 v5.4.0, 0.50 v5.3.0, 0.75 v5.2.0, 0.50 v5.0.0, 0.25 v4.1.0, 0.33 v4.0.1, 0.67 v4.0.0
% Syntax   : Number of formulae    :    3 (   0 unit;   2 type;   0 defn)
%            Number of atoms       :   11 (   0 equality;   7 variable)
%            Maximal formula depth :    9 (   5 average)
%            Number of connectives :   10 (   0   ~;   0   |;   1   &;   6   @)
%                                         (   0 <=>;   3  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :    6 (   6   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    5 (   2   :;   0   =)
%            Number of variables   :    5 (   1 sgn;   2   !;   1   ?;   2   ^)
%                                         (   5   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_NEQ_NAR

% Comments : This problem is from the TPS library. Copyright (c) 2009 The TPS
%            project in the Department of Mathematical Sciences at Carnegie
%            Mellon University. Distributed under the Creative Commons copyleft
%            license: http://creativecommons.org/licenses/by-sa/3.0/
%          : Polymorphic definitions expanded.
%------------------------------------------------------------------------------
thf(a_type,type,(
    a: $tType )).

thf(cOPEN,type,(
    cOPEN: ( a > $o ) > $o )).

thf(cTHM625A_pme,conjecture,
    ( ! [K: ( a > $o ) > $o] :
        ( ! [Xx: a > $o] :
            ( ( K @ Xx )
           => ( cOPEN @ Xx ) )
       => ( cOPEN
          @ ^ [Xx: a] :
            ? [S: a > $o] :
              ( ( K @ S )
              & ( S @ Xx ) ) ) )
   => ( cOPEN
      @ ^ [Xx: a] : $false ) )).

%------------------------------------------------------------------------------
